<%@ Page Language="C#" EnableEventValidation="false" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.Reporting.ReportMilitaryStatus" Codebehind="ReportMilitaryStatus.aspx.cs" %>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="~/Controls/Custom/BPR/UserControlMilitaryStatus.ascx" TagName="UserControlMilitaryStatus"
    TagPrefix="UC" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

     <script type="text/javascript">
        $(document).ready(function() {
            $('#<%= UserControlMilitaryStatus.ClientID %>').change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelDutyStatusReport.ClientID %>').hide();
            });
       });
    </script>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Reports > Duty Status Report"/>
    </div><br /> 
    <asp:Panel ID="PanelSelectParameters" runat="server" GroupingText=" Selection Criteria (Please select at least one)">
        <asp:Panel ID="PanelStatus" runat="server">
            <UC:UserControlMilitaryStatus ID="UserControlMilitaryStatus" runat="server" />
        </asp:Panel>
        <asp:Panel ID="Panel1" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="Button1" Text="Run Report"
                            Width="120px" ValidationGroup="OnRunReport" OnClick="ButtonRunReport_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="Button2" runat="server" Text="Print/Export Report" Width="150px"
                        ValidationGroup="OnRunReport" OnClick="ButtonPrintReport_Click" Style="margin-left: 0px; margin-top: 8px" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                     <asp:Button runat="server" ID="Button3" Text="Clear"
                         Width="120px" OnClick="ButtonClear_Click" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </asp:Panel>
        <asp:Panel ID="PanelReportViewer" runat="server">
            <rsweb:ReportViewer ID="ReportViewerReport" runat="server" Width="100%" ProcessingMode="Remote"
                Height="700px">
            </rsweb:ReportViewer>
        </asp:Panel>

        <asp:Panel ID="PanelDutyStatusReport" runat="server" GroupingText=" Report Results ">
        <center>
            <asp:Label ID="LabelReportCriteria" runat="server" Text="" Font-Bold="true" Font-Size="Large"></asp:Label></center>
        <br />
        <asp:GridView ID="GridViewDutyStatus" runat="server" DataSourceID="DataSourceDutyStatusReport"
            AutoGenerateColumns="False" Width="100%" AllowPaging="false" AllowSorting="false" ShowFooter="True"
            OnRowDataBound="GridViewDutyStatus_RowDataBound" Caption="Duty Status Report">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.
            </EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="Duty Status" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForDutyStatus" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Duty_Status")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotal" runat="server" SkinID="DataLabel" Text="Grand Total" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Participant"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForParticipant" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Participant")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalParticipant" runat="server" SkinID="DataLabel" Text="Participant" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Eligible/Reviewed-Eligible" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForReviewedEligible" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Eligible_Reviewed_Eligible")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalReviewedEligible" runat="server" SkinID="DataLabel" Text="Eligible/ReviewedEligible" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Not Eligible/Reviewed-Not Eligible" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForReviewedNotEligible" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Not_Eligible_Reviewed_Not_Eligible")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalReviewedNotEligible" runat="server" SkinID="DataLabel" Text="NotEligible/Reviewed-NotEligible" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Review" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForReview" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Review")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalReview" runat="server" SkinID="DataLabel" Text="Review" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="No Consent" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelForNoConsent" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("No_Consent")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalNoConsent" runat="server" SkinID="DataLabel" Text="No Consent" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Total" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelTotalCount" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Total")) %>'></asp:Label>
                    </ItemTemplate>
                    <FooterTemplate>
                        <asp:Label ID="LabelGrandTotalAll" runat="server" SkinID="DataLabel" Text="Toal All" Font-Bold="true" />
                    </FooterTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </asp:Panel>
        <asp:ObjectDataSource ID="DataSourceDutyStatusReport" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetMilitaryStatusReport" EnablePaging="false" SelectCountMethod="GetMilitaryStatusReportCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="UserControlMilitaryStatus" Name="dutyStatusAtFirstLogin" PropertyName="DutyStatusCurrent"
                Type="string" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField runat="server" ID="HiddenFieldSort" />
</asp:Content>
